<?php
/**
 * Plugin Name: Wbox时间轴文章归档
 * Author: 西部盒子
 * Author URI: http://blog.wbox8.com
 * Version: 1.2
 * Plugin URI: http://wbox.taobao.com
 * Description: 新建页面添加简码 <code>[wboxtimeline]</code>
 */
add_shortcode('wboxtimeline', 'wboxtimeline');
function wboxtimeline() {
    $css  = get_option('wb_time_line_css');
    $html = <<<wbox
	<style>
	.wbcss-archive {
		position: relative;
		font-size: 14px;
		color: rgba(0, 0, 0, 0.6);
	}
	.wbcss-archive:before {
		content: "";
		width: 3px;
		background-color: rgba(0, 0, 0, 0.05);
		position: absolute;
		top: 0;
		bottom: 0;
		left: 100px;
	}
	.wbcss-archive h3{
		border:0 !important;
	}
	h3.archive-year {
		display: inline-block;
		background-color: #fafafa;
		border: 1px solid rgba(0, 0, 0, 0.05);
		color: rgba(0, 0, 0, 0.44);
		padding: 1px 0;
		width: 120px;
		margin-left: 40px;
		text-align: center;
		postion: relative;
		border-radius: 3px;
		margin-top: 30px;
		margin-bottom: 10px;
		position: relative;
	}
	h3.archive-month {
		position: relative;
		font-weight: 700;
		margin:0 0 15px;
		padding:0;
		font-size: 16px;
    	line-height: 25px;
    	color: #999;
	}
	.archive-month:before,
	.archive-month:after {
		content: "";
		background-color: #fff;
		height: 19px;
		width: 19px;
		border-radius: 100%;
		position: absolute;
		left: 92px;
		top: 3px;
	}
	.archive-month:after {
		height: 15px;
		width: 15px;
		background-color: #eee;
		left: 94px;
		top: 5px;
	}
	.archive-month:hover:after {
		background-color: #ec8c35;
	}
	.wbcss-ul {
		margin:0 0 30px 100px !important;
		margin-left: 100px !important;
		margin-bottom: 30px !important;
	}
	.wbcss-ul .date {
		margin-left: -80px;
		width: 80px;
		display: inline-block;
	}
	.wbcss-ul li {
		margin:0 !important;
		position: relative;
		padding-left: 15px;
		list-style: none !important;
	}
	.wbcss-ul li:before,
	.wbcss-ul li:after {
		content: "";
		background-color: #fff;
		height: 13px;
		width: 13px;
		border-radius: 100%;
		position: absolute;
		left: -5px;
		top: 7px;
	}
	.wbcss-ul li:after {
		height: 9px;
		width: 9px;
		background-color: #eee;
		left: -3px;
		top: 9px;
	}
	.wbcss-ul li:hover:after {
		background-color: #ec8c35;
	}
	.wb-paged{
		margin: 0;
    	padding: 0;
    	text-align: center;
	}
	.wb-paged a{
		display: inline-block;
    	margin: 0 5px;
    	font-size: 14px;
    	color: #555;
    	line-height: 20px;
    	padding: 3px 10px;
    	background: #fff;
    	border: 1px #ddd solid;
	}
	.wb-paged a:hover{
		background: #eee;
	}
	.wb-paged span{
		display: inline-block;
    	margin: 0 5px;
    	font-size: 14px;
    	line-height: 20px;
    	color: #555;
    	padding: 0px;
	}
	{$css}
	</style>
wbox;
    $html .= '<div class="wbcss-archive">';
    $paged = get_query_var('paged');
    $args  = array(
        'post_type'           => 'post',
        'posts_per_page'      => get_option('wb_time_line_showposts', 20),
        'ignore_sticky_posts' => 1,
        'category__not_in'    => explode(',', get_option('wb_time_line_category_notin')),
        'paged'               => $paged ? $paged : 1,
         );
    $the_query     = new WP_Query($args);
    $posts_rebuild = array();
    while ($the_query->have_posts()): $the_query->the_post();
        $post_year                              = get_the_time('Y');
        $post_mon                               = get_the_time('m');
        $posts_rebuild[$post_year][$post_mon][] = '<li><a href="' . get_permalink() . '">' . get_the_title() . '</a> <em>(' . get_comments_number('0', '1', '%') . ')</em></li>';
    endwhile;
    wp_reset_postdata();
    foreach ($posts_rebuild as $key => $value) {
        $output .= '<h3 class="archive-year">' . $key . '</h3>';
        $year = $key;
        foreach ($value as $key_m => $value_m) {
            $output .= '<h3 class="archive-month">' . $year . ' - ' . $key_m . '</h3><ul class="wbcss-ul">';
            foreach ($value_m as $key => $value_d) {
                $output .= $value_d;
            }
            $output .= '</ul>';
        }
    }
    $html .= $output;
    $html .= '</div>';
    $html .= wbox_paged_nav($the_query, $paged, 2);
    return wbox_compress_html($html);
}

function wbox_paged_nav($query, $paged, $p = 2) {
    $html     = '';
    $max_page = $query->max_num_pages;
    if ($max_page > 1) {
        if (empty($paged)) {
            $paged = 1;
        }
        $html .= '<div class="wb-paged">';
        if ($paged > $p + 1) {
            $html .= wboxp_link(1, '最前页', '«');
        }

        if ($paged > 1) {
            $html .= wboxp_link($paged - 1, '上一页', '‹');
        }
        if ($paged > $p + 2) {
            $html .= '... ';
        }
        for ($i = $paged - $p; $i <= $paged + $p; $i++) {
            if ($i > 0 && $i <= $max_page) {
                if ($i == $paged) {
                    $html .= "<span class='page-numbers current'>{$i}</span>";
                } else {
                    $html .= wboxp_link($i);
                }
            }
        }
        if ($paged < $max_page - $p - 1) {
            $html .= '<span class="page-numbers">...</span>';
        }
        if ($paged < $max_page) {
            $html .= wboxp_link($paged + 1, '下一页', '›');
        }
        if ($paged < $max_page - $p) {
            $html .= wboxp_link($max_page, '最后页', '»');
        }
        $html .= '</div>';
    }
    return $html;
}
function wboxp_link($i, $title = '', $linktype = '') {
    if ($title == '') {
        $title = "第 {$i} 页";
    }

    if ($linktype == '') {
        $linktext = $i;
    } else {
        $linktext = $linktype;
    }
    return "<a class='page-numbers' href='" . esc_html(get_pagenum_link($i)) . "' title='{$title}'>{$linktext}</a> ";
}

function wbox_compress_html($string) {
    $string  = str_replace("\r\n", '', $string); //清除换行符
    $string  = str_replace("\n", '', $string); //清除换行符
    $string  = str_replace("\t", '', $string); //清除制表符
    $pattern = array(
        "/> *([^ ]*) *</", //去掉注释标记
        "/[\s]+/",
        "/<!--[^!]*-->/",
        "/\" /",
        "/ \"/",
        "'/\*[^*]*\*/'",
    );
    $replace = array(
        ">\\1<",
        " ",
        "",
        "\"",
        "\"",
        "",
    );
    return preg_replace($pattern, $replace, $string);
}
//后台设置页面
function wbox_time_line_add_menu() {
    add_menu_page('时间轴设置 - BY 西部盒子', '时间轴设置', 'edit_themes', 'wbox_time_line_setings', 'wbox_time_line_display_function', '', 999);
}
add_action('admin_menu', 'wbox_time_line_add_menu');
function wbox_time_line_display_function() {
    $update = false;
    if ($_POST['wb_time_line_showposts']) {
        update_option('wb_time_line_showposts', trim($_POST['wb_time_line_showposts']));
        update_option('wb_time_line_category_notin', trim($_POST['wb_time_line_category_notin']));
        update_option('wb_time_line_css', trim($_POST['wb_time_line_css']));
        $update = true;
    }
    ?>
	<div class="wrap" id="profile-page">
	<?php if ($update) {
        echo '<div class="notice notice-info"><p>更新成功</p></div>';
    }
    ?>
    <form method="post" name="wbox_seting" id="wbox_seting">
    <h2>时间轴设置</h2>
    <table class="form-table">
	<tbody>
		<tr class="form-field">
		<th scope="row"><label for="wb_time_line_showposts">每页显示条数</label></th>
		<td>
			<input name="wb_time_line_showposts" type="text" id="wb_time_line_showposts" value="<?php echo get_option('wb_time_line_showposts'); ?>" style="max-width: 500px;" />
			<p>不设置默认显示20条，设置为-1显示全部。</p>

		</td>
		</tr>

		<tr class="form-field">
		<th scope="row"><label for="wb_time_line_category_notin">要排除的分类</label></th>
		<td>
			<input name="wb_time_line_category_notin" type="text" id="wb_time_line_category_notin" value="<?php echo get_option('wb_time_line_category_notin'); ?>" style="max-width: 500px;" />
			<p>多个分类ID请用英文逗号分开，请对照下面分类对照表进行设置。</p>
		</td>
		</tr>

		<tr class="form-field">
		<th scope="row"><label for="wb_time_line_css">额外的CSS样式</label></th>
		<td>
			<textarea name="wb_time_line_css" id="wb_time_line_css" rows="5" cols="30"><?php echo get_option('wb_time_line_css'); ?></textarea>
			<p>自定义CSS区域，会在时间轴上方的CSS区域调用，前后不用添加style标签。</p>
		</td>
		</tr>
	</tbody>
	</table>
	<?php submit_button('保存设置');?>
    </form>
    <h3>插件使用方法：</h3>
    <p>新建一个页面，在内容区域输入简码： <code>[wboxtimeline]</code></p>
    <h3>分类对照表：<small style="color: #e00">分类 - id</small></h3>
    <style>.wb-cat{margin-right: 20px;background: #d2e9f3;padding: 5px}</style>
    <p><?php
    foreach (get_categories() as $cat) {
        echo '<span class="wb-cat">' . $cat->cat_name . ' <code>' . $cat->cat_ID . '</code></span>';
    }
    ?></p>
    <p style="position: fixed;bottom: 20px;right: 20px;">时间轴插件由 <a href="https://blog.wbox8.com/" target="_blank">西部盒子</a> 提供</p>
    </div>
<?php }